/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui.entry;

import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.SliderButton;
import io.github.jamalam360.jamlib.config.Slider;
import io.github.jamalam360.jamlib.config.WithinRange;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class NumberConfigEntry<T, V extends Number>
extends ConfigEntry<T, V> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private final Function<String, Number> parser;
    private final Pattern regex;
    @Nullable
    private class_342 editBox = null;
    @Nullable
    private SliderButton slider = null;

    public NumberConfigEntry(String modId, String configName, ConfigField<T, V> field) {
        super(modId, configName, field);
        Class<V> c = field.getElementType();
        if (c == Float.TYPE || c == Float.class) {
            this.parser = Float::parseFloat;
            this.regex = Pattern.compile("^-?\\d*\\.?\\d*$");
        } else if (c == Double.TYPE || c == Double.class) {
            this.parser = Double::parseDouble;
            this.regex = Pattern.compile("^-?\\d*\\.?\\d*$");
        } else if (c == Integer.TYPE || c == Integer.class) {
            this.parser = Integer::parseInt;
            this.regex = Pattern.compile("^-?\\d*$");
        } else if (c == Long.TYPE || c == Long.class) {
            this.parser = Long::parseLong;
            this.regex = Pattern.compile("^-?\\d*$");
        } else {
            throw new IllegalArgumentException("Unsupported class for NumberConfigEntry " + String.valueOf(c));
        }
    }

    @Override
    public List<class_339> createElementWidgets(int left, int width) {
        Number current = (Number)this.getFieldValue();
        if (this.field.isAnnotationPresent(Slider.class)) {
            WithinRange range = this.field.getAnnotation(WithinRange.class);
            if (current == null) {
                current = range.min();
            }
            this.slider = new SliderButton(left, 0, width, 20, this.getComponent(current), range.min(), range.max(), current.doubleValue(), value -> {
                this.setFieldValue(value);
                return this.getComponent((Number)value);
            });
            return List.of(this.slider);
        }
        this.editBox = new class_342(class_310.method_1551().field_1772, left, 0, width, 20, class_5244.field_39003);
        this.editBox.method_1852(DECIMAL_FORMAT.format(current.doubleValue()));
        this.editBox.method_1890(s -> this.regex.matcher((CharSequence)s).matches());
        this.editBox.method_1863(s -> {
            if (!s.isEmpty()) {
                this.setFieldValue(this.parser.apply((String)s));
            }
        });
        return List.of(this.editBox);
    }

    private class_2561 getComponent(Number value) {
        return class_2561.method_43470((String)DECIMAL_FORMAT.format(value.doubleValue()));
    }

    @Override
    public void reset() {
        super.reset();
        if (this.editBox != null) {
            this.editBox.method_1852(DECIMAL_FORMAT.format(((Number)this.getFieldValue()).doubleValue()));
        } else if (this.slider != null) {
            this.slider.setValue(((Number)this.getFieldValue()).doubleValue());
        }
    }
}

